import { createTheme } from "@mui/material/styles";
export const Tema = createTheme({
  palette: {
    mode: "light",
    primary: {
      main: "#183ca9",
    },
    medal: {
      first: "#8a862b",
      second: "#506472",
      third: "#7f6339",
      badge: "#c10a16",
      star: "#ffb118",
    },
    secondary: {
      main: "#c10a16",
      dark: "#5b050a",
    },
    background: {
      default: "#e9eefe",
      paper: "#f9f9fa",
    },
    text: {
      primary: "#303030",
    },
    success: {
      main: "#149e30",
    },
    divider: "#c0c0c2",
  },
  shape: {
    borderRadius: 16,
  },
  spacing: 8,
  components: {
    MuiPaper: {
      styleOverrides: {
        root: {
          margin: "8px",
          padding: "8px",
        },
      },
    },
    MuiLinearProgress: {
      styleOverrides: {
        root: {
          margin: "15px",
          padding: "8px",
          borderRadius: "25px",
        },
      },
    },
  },
});
