import ExpandMoreIcon from "@mui/icons-material/ExpandMore";
import { AccordionSummary } from "@mui/material";
import { AccordionDetails } from "@mui/material";
import { Typography } from "@mui/material";
import { Accordion } from "@mui/material";
import { RankingItem } from "./RankingItem";

export const Ranking = ({ data }) => {
  return (
    <div>
      {
        <Accordion defaultExpanded={true}>
          <AccordionSummary expandIcon={<ExpandMoreIcon />}>
            <Typography variant="h4">Ranking</Typography>
          </AccordionSummary>
          <AccordionDetails sx={{ overflow: "auto", padding: "0px" }}>
            {data.map((pos) => {
              return (
                <RankingItem
                  key={pos.score + pos.star}
                  position={pos.position}
                  usrName={pos.usrName}
                  score={pos.score}
                  star={pos.star}
                />
              );
            })}
          </AccordionDetails>
        </Accordion>
      }
    </div>
  );
};
