import "@fontsource/roboto/300.css";
import "@fontsource/roboto/400.css";
import "@fontsource/roboto/500.css";
import "@fontsource/roboto/700.css";
import { ThemeProvider } from "@mui/material/styles";
import { Grid } from "@mui/material";
import { ChatError } from "./ChatError";
import { Pregunta } from "./Pregunta";
import { Ranking } from "./Ranking";
import { Activos } from "./Activos";
import { Tema } from "./Tema";
import dataC from "./jsons/chatError";
import dataP from "./jsons/pregunta";
import dataA from "./jsons/activos";
import dataR from "./jsons/ranking";

export const Pizarra = () => {
  return (
    <ThemeProvider theme={Tema}>
      <Grid container spacing={2} justifyContent="space-between">
        <Grid item xs={12}>
          {/*(1) raw(string), numId(int), time(int [0,100]) */}
          <Pregunta data={dataP} />
        </Grid>
        <Grid item>
          {/*(n) usrName(string), wrongText(string) */}
          <ChatError data={dataC} />
        </Grid>
        <Grid item xs>
          {/*(n) usrName(string), emoji(int[0,3][nada,estrella,pensando,durmiendo]), isGreen(bool)*/}
          <Activos data={dataA} />
        </Grid>
        <Grid item>
          {/*(3)  position((string)(first|second|third)), usrName(string), score(int), star(int) */}
          <Ranking data={dataR} />
        </Grid>
      </Grid>
    </ThemeProvider>
  );
};
