import ExpandMoreIcon from "@mui/icons-material/ExpandMore";
import { AccordionSummary } from "@mui/material";
import { AccordionDetails } from "@mui/material";
import { Typography } from "@mui/material";
import { Accordion } from "@mui/material";
import { Mensaje } from "./Mensaje";

export const ChatError = ({ data }) => {
  return (
    <div>
      <Accordion defaultExpanded={true}>
        <AccordionSummary expandIcon={<ExpandMoreIcon />}>
          <Typography variant="h4" color={"secondary.main"}>
            Intentos
          </Typography>
        </AccordionSummary>
        <AccordionDetails
          sx={{ overflow: "auto", width: 318, height: 352, padding: "0px" }}
        >
          {data.map((msj) => {
            return (
              <Mensaje
                key={msj.usrName + msj.wrongText}
                usrName={msj.usrName}
                wrongText={msj.wrongText}
              />
            );
          })}
        </AccordionDetails>
      </Accordion>
    </div>
  );
};
