import React, { useState } from 'react';
import { Editor, EditorState, RichUtils } from 'draft-js';
import 'draft-js/dist/Draft.css';
import Button from '@mui/material/Button';
import { createTheme,ThemeProvider, Grid, TextField } from '@mui/material/styles';
import BorderColorIcon from '@mui/icons-material/BorderColor';
import UndoIcon from '@mui/icons-material/Undo';
import RedoIcon from '@mui/icons-material/Redo';
import './texto.css';


const theme = createTheme({
  palette: {
    primary: {
      light: '#4663ba',
      main: '#183CA9',
      dark: '#102a76',
    },
    secondary: {
      light: '#f4916d',
      main: '#F27649',
      dark: '#a95233',
    },
  },
});

const TextEditor = () => {
  const [editorState, setEditorState] = useState(EditorState.createEmpty());
  const [score, setScore] = useState('');
  const [seconds, setSeconds] = useState('');

  const handleUndo = () => {
    const newState = EditorState.undo(editorState);
    setEditorState(newState);
  };

  const handleRedo = () => {
    const newState = EditorState.redo(editorState);
    setEditorState(newState);
  };

  const handleAsk = () => {
    let newEditorState = RichUtils.toggleInlineStyle(editorState, 'BOLD');
    newEditorState = RichUtils.toggleInlineStyle(newEditorState, 'HIGHLIGHT');

    setEditorState(newEditorState);
  };

  const handleSend = () => {

    const contentState = editorState.getCurrentContent();
    const selection = editorState.getSelection();
    const blockKey = selection.getStartKey();
    const selectedBlock = contentState.getBlockForKey(blockKey);
    const blockText = selectedBlock.getText();
    const inlineStyles = selectedBlock.getCharacterList();
  
    let outputText = '';
    let isBold = false;
  
    for (let i = 0; i < blockText.length; i++) {
      const char = blockText[i];
      const charStyle = inlineStyles.get(i).getStyle();
  
      if (charStyle.has('BOLD')) {
        if (!isBold) {
          outputText += '<lq>';
          isBold = true;
        }
      } else {
        if (isBold) {
          outputText += '</lq>';
          isBold = false;
        }
      }
  
      outputText += char;
    }
  
    if (isBold) {
      outputText += '</lq >';
    }
    
    if (editorState.getCurrentContent().getPlainText().trim() === '') {
      alert('Error: El editor de texto no puede estar vacío.');
      return;
    }

    if (!editorState.getCurrentInlineStyle().has('BOLD')) {
      alert('Error: Debe seleccionar al menos una pregunta.');
      return;
    }

    if (score === '') {
      alert('Error: Debe de poner un puntaje.');
      return;
    }

    if (parseInt(score) <= 1){
      alert("El puntaje debe ser un número entero positivo igual o mayor a 1.");
      return
    }

    if (seconds === '' ){
      alert("Debe de poner una cantidad de segundos ");
      return
    }

    if (parseInt(seconds) <= 10 || (parseInt(seconds) % 1 !== 0)){
      alert("Segundos deben ser un número entero positivo igual o mayor a 10S.");
      return
    }



    //output text es lo que se va a enviar a pregunta
  
    //Aquí se envía OutputeText a la base de datos
    console.log(outputText);
    console.log('Score:', score);
    console.log('Seconds:', seconds);

    // limpia el editor de texto
    setEditorState(EditorState.createEmpty());
    setScore('');
    setSeconds('');
  };
  

  return (
    <div>
      <ThemeProvider theme={theme}>
        <div className="editor-controls">
          <div className="icon-container">
            <Button onClick={handleUndo} disabled={!editorState.getUndoStack().size} className="icon-button">
              <UndoIcon />
            </Button>
            <Button onClick={handleRedo} disabled={!editorState.getRedoStack().size} className="icon-button">
              <RedoIcon />
            </Button>
            <Button onClick={handleAsk} variant='contained' className="icon-button">
              <BorderColorIcon />
            </Button>
          </div>
        <input
          className="editor-input"
          type="number" min="1" onKeyPress={(event) => (event.charCode !== 8 && event.charCode !== 0) || (event.charCode >= 48 && event.charCode <= 57)}
          placeholder="Puntaje"
          value={score}
          onChange={(e) => setScore(e.target.value)}
          style={{ width: '123px', height: '17px' }}
        />
        <input
          className="editor-input"
          type="number" min="10" step='1'
          placeholder="Segundos"
          value={seconds}
          onChange={(e) => setSeconds(e.target.value)}
          style={{ width: '123px', height: '17px' }}
        />
        </div>  
      <div>
        <Editor
          editorState={editorState} 
          onChange={setEditorState}
          placeholder="Escribe la siguiente pregunta"  />
      </div>
        <div className="save-question">
          <div style={{justifyContent:'flex-start', paddingRight:'8px'}}>
            Marca cada respuesta con el boton de <BorderColorIcon/>
            </div>
          <Button onClick={handleSend} variant='contained' color='secondary'>Crear Pregunta</Button>
        </div>
        
        </ThemeProvider>
    </div>
  );
};

export default TextEditor;
